VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CCGIEmp"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Implements ICGIApp

'The following objects are created and maintained by the CGILibrary
'DLL. The CGILibrary passes these objects through the Create() method.
Private m_Cgi As CCGI       'Encapsulates CGI information
Private m_Log As CeventLog  'Used to write to the application log file
Private m_StdIo As CStdIO   'Used to write to standard output

Private m_bIsCreated As Boolean

'******* Application specific member variables *******

'The employee business object
Private m_Emp As Cemployee

'Action enumeration
Private Enum Action
    acSave
    acRetrieveAll
End Enum

'Useful constants
Private Const MISSING_INFO As String = "Some employee information is missing or invalid"

Private Const TABLE_HEADER As String = "<TABLE BORDER=1><THEAD BGCOLOR=GRAY FGCOLOR=WHITE><TD WIDTH=65>ID</TD><TD>NAME</TD><TD>PAY RATE</TD><TD>HOURS</TD><TD>START DATE</TD></THEAD>"

'****************************************************************
'Initializes the CGI, Error log, and standard IO references.
'These objects are created by the CGILibrary.
'****************************************************************
Private Function ICGIApp_Create(CGI As CCGI, Log As CeventLog) As Boolean
    Set m_Cgi = CGI
    Set m_Log = Log
    Set m_StdIo = CGI.StdIO
    m_bIsCreated = True

    ICGIApp_Create = True
End Function

Private Function ICGIApp_PreProcess() As Boolean
    'Assert if Create() has not been called
    Debug.Assert m_bIsCreated
    
    m_Log.WriteEntry "PreProcess()"
    
    'Send the response header.
    m_StdIo.WriteOut "Content-type: text/html" & vbCrLf & vbCrLf
    m_StdIo.WriteOut "<HTML>"
    m_StdIo.WriteOut "<BODY>"
    
    'Verify the Action parameter exists.
    If IsParamsValid() Then
    
        'Initialize the Employee bus obj.
        Set m_Emp = New Cemployee
        
        'If Debug parameter is 1 then return CGI info.
        If m_Cgi.Params("Debug") = 1 Then
            m_StdIo.WriteOut "<H1>CGI Info Received</H1><br>"
            WriteParams
            WriteEnvirons
            m_StdIo.WriteOut "<hr>"     'Horizontal Line
        End If
    
    Else
        'Action parameter does not exist.  Return an error message.
        m_StdIo.WriteOut "<h1>Invalid Query String!</h1>"
        m_StdIo.WriteOut "<p>Query string does not contain a valid Action value.<p>"
        
        'Raising an error to stop processing.  Error handled in the
        'CGILibrary and logged to the log file.
        Err.Raise 10000, "CGIEmpMain.PreProcess()", "Invalid query string"
        
    End If
    
    ICGIApp_PreProcess = True
End Function

'****************************************************************
'Format and send the CGI environmental variables.  Used when the
'Debug parameter is set.
'****************************************************************
Private Sub WriteEnvirons()
    Dim vKey As Variant
    
    m_StdIo.WriteOut "<H2>Environmental Variables:</H2>"
    m_StdIo.WriteOut "<p>"
    For Each vKey In m_Cgi.Environs
        m_StdIo.WriteOut vKey & " = " & m_Cgi.Environs(vKey) & "<br>"
    Next vKey
    m_StdIo.WriteOut "</p>"
End Sub

'****************************************************************
'Format and send the CGI query string parameters.  Used when the
'Debug parameter is set.
'****************************************************************
Private Sub WriteParams()
    Dim vKey As Variant
    
    m_StdIo.WriteOut "<H2>Parameters:</H2>"
    m_StdIo.WriteOut "<p>"
    m_StdIo.WriteOut "Query String: " & m_Cgi.QueryString & "<br>"
    For Each vKey In m_Cgi.Params
        m_StdIo.WriteOut vKey & " = " & m_Cgi.Params(vKey) & "<br>"
    Next vKey
    m_StdIo.WriteOut "</p>"
End Sub

'****************************************************************
'Validate Action parameter is present and is a number.
'****************************************************************
Private Function IsParamsValid() As Boolean
    Dim vAction As Variant
    
    vAction = m_Cgi.Params("Action")
    
    If (IsNumeric(vAction) And Not IsEmpty(vAction)) Then
        IsParamsValid = True
    Else
        IsParamsValid = False
    End If
    
End Function

Private Function ICGIApp_Process() As Boolean
    'Assert if Create() has not been called
    Debug.Assert m_bIsCreated
  
    m_Log.WriteEntry "Process()"
    
    If m_Cgi.Params("Action") = acSave Then
        SaveEmployee
    Else
        RetrieveEmps
    End If
        
    ICGIApp_Process = True
End Function

Private Sub RetrieveEmps()
    Dim sMsg As String
    Dim rs As ADODB.Recordset
    
    m_Log.WriteEntry "RetrieveEmps()"
     
    'Get the recordset from the employee object
    Set rs = m_Emp.GetAll()
    rs.Open
    With m_StdIo
        'Begin Table
        .WriteOut TABLE_HEADER
        Do While Not rs.EOF
            .WriteOut "<TR>"
            .WriteOut "<TD>" & rs("ID") & "</TD>"
            .WriteOut "<TD>" & rs("Name") & "</TD>"
            .WriteOut "<TD>" & FormatCurrency(rs("PayRate")) & "</TD>"
            .WriteOut "<TD>" & rs("Hours") & "</TD>"
            .WriteOut "<TD>" & Format(rs("StartDate"), "mm/dd/yyyy") & "</TD>"
            .WriteOut "</TR>"
            rs.MoveNext
        Loop
        .WriteOut "</TABLE>"
    End With
    
    rs.Close
End Sub

Private Sub SaveEmployee()
    Dim sEmployee As String
    
     m_Log.WriteEntry "SaveEmployee()"
    
    'Ignore errors while setting the employee properties. This is
    'to avoid "Type Mismatch" errors if some parameters are missing.
    On Error Resume Next
    
    With m_Emp
        .Name = m_Cgi.Params("Name")
        .SSN = m_Cgi.Params("ID")
        .Hours = m_Cgi.Params("Hours")
        .PayRate = m_Cgi.Params("PayRate")
        .StartDate = m_Cgi.Params("StartDate")
    End With
    
    'Stop ignoring errors
    On Error GoTo 0
    
    'If employee object is valid then save it
    If m_Emp.IsValid Then
        m_StdIo.WriteOut "<h2>Employee Saved!</h2>"
        m_StdIo.WriteOut m_Emp.AsHTML()
        m_Log.WriteEntry "SaveEmployee()" & vbCrLf & m_Emp.AsString()
    Else
        'Employee is missing some data or data is invalid.
        m_StdIo.WriteOut "<h2>Employee Save Failed!</h2>"
        m_StdIo.WriteOut "<p>" & MISSING_INFO & "</p>"
        
        'Log the error too.
        m_Log.WriteEntry "Save Error: " & MISSING_INFO
    End If
End Sub

Private Function ICGIApp_PostProcess() As Boolean
   'Assert if Create() has not been called
    Debug.Assert m_bIsCreated

    m_Log.WriteEntry "PostProcess()"
    
    m_StdIo.WriteOut "</BODY>"
    m_StdIo.WriteOut "</HTML>"
    m_StdIo.WriteOut ""
    Set m_Emp = Nothing
    
    ICGIApp_PostProcess = True
End Function

Private Property Get ICGIApp_CGI() As CCGI
    Set ICGIApp_CGI = m_Cgi
End Property

Private Property Get ICGIApp_Log() As CeventLog
    Set ICGIApp_Log = m_Log
End Property

Private Sub Class_Initialize()
    m_bIsCreated = False
End Sub

Private Sub Class_Terminate()
    Set m_Cgi = Nothing
    Set m_Log = Nothing
    Set m_StdIo = Nothing
End Sub

